;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_4.inc
;;   Version: 2.4, Updated on 2004/10/27 at 18:26:18
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_4 API's.
;--------------------------------------------------

PWM8_4_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_4_INT_REG:                            equ 0x0df
PWM8_4_INT_MASK:                           equ 0x02


;--------------------------------------------------
; Constants for PWM8_4 user defined values
;--------------------------------------------------

PWM8_4_PERIOD:                             equ 0xfe
PWM8_4_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_4
;--------------------------------------------------

PWM8_4_COUNTER_REG:                    equ 0x44   ; DR0 Count register
PWM8_4_PERIOD_REG:                     equ 0x45   ; DR1 Period register
PWM8_4_COMPARE_REG:                    equ 0x46   ; DR2 Compare register
PWM8_4_CONTROL_REG:                    equ 0x47   ; Control register
PWM8_4_FUNC_REG:                       equ 0x44   ; Function register
PWM8_4_INPUT_REG:                      equ 0x45   ; Input register
PWM8_4_OUTPUT_REG:                     equ 0x46   ; Output register


;--------------------------------------------------
; PWM8_4 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_4_Start_M
   or    reg[PWM8_4_CONTROL_REG],  PWM8_4_CONTROL_REG_START_BIT
   endm

   macro PWM8_4_Stop_M
   and   reg[PWM8_4_CONTROL_REG], ~PWM8_4_CONTROL_REG_START_BIT
   endm

   macro PWM8_4_EnableInt_M
   M8C_EnableIntMask PWM8_4_INT_REG, PWM8_4_INT_MASK
   endm

   macro PWM8_4_DisableInt_M
   M8C_DisableIntMask PWM8_4_INT_REG, PWM8_4_INT_MASK
   endm


; end of file PWM8_4.inc
